package pt.caf_pbs.schooldiskapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import pt.caf_pbs.schooldiskapi.exceptions.DuplicatedDataException;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@JsonIgnoreProperties(value = {"all"})
public class SubjectContainer implements Serializable {
    private List<Subject> subjects;
    private EnrollContainer enrolls;
    private InstructorContainer instructors;

    public SubjectContainer() {
        subjects = new ArrayList<Subject>();
    }

    public List<Subject> getSubjects() {
        return subjects;
    }

    public void setSubjects(List<Subject> subjects) {
        this.subjects = subjects;
    }

    public EnrollContainer getEnrolls() {
        return enrolls;
    }

    public void setEnrolls(EnrollContainer enrolls) {
        this.enrolls = enrolls;
    }

    public InstructorContainer getInstructors() {
        return instructors;
    }

    public void setInstructors(InstructorContainer instructors) {
        this.instructors = instructors;
    }

    private Subject search(String initials) {
        Subject subject;
        Iterator<Subject> it = this.subjects.iterator();
        while (it.hasNext()) {
            subject = it.next();
            if (subject.isEqualTo(initials)) {
                return subject;
            }
        }
        return null;
    }

    public List<Subject> getAll() {
        List<Subject> newlist = new ArrayList();
        newlist.addAll(this.subjects);
        return newlist;
    }

    public Subject get(String initials) {
        Subject subject = search(initials);
        return subject;
    }

    public void add(Subject obj) {
        Subject subject = search(obj.getInitials());
        if (subject == null) {
            this.subjects.add(obj);
        } else {
            String msg = "Subject: " + obj.getInitials() + " already exists";
            throw new DuplicatedDataException(msg);
        }
    }

    public void remove(String initials) {
        Subject subject = search(initials);
        if (subject != null) {
            this.subjects.remove(subject);
        }
    }

    public void update(String initials, String designation) {
        Subject subject = search(initials);
        if (subject != null) {
            subject.setDesignation(designation);
        }
    }
}
